﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using IndianHealthService.BMXNet.EHR;
using CIA_CSS;
using System.Runtime.InteropServices;
using IndianHealthService.BMXNet.Model;
using IndianHealthService.BMXNet.EHR.Model;
using IndianHealthService.BMXNet.EHR.Services;

namespace IndianHealthService.BMXNet.Example.CrossComponent.EHR
{
    /// <summary>
    /// //////////////////////////////////Copy from colon after classname to end of file
    /// </summary>
    public partial class UserInfoComponent : CSS_Patient.ICSS_PatientEvents, CSS_Encounter.ICSS_EncounterEvents, CIA_CSS.ICSS_SessionEvents, IEhrEvents, IEhrComponent
    {

        #region Copy Region into partial EHR file plus include interfaces noted above

        protected override void Dispose(bool disposing)
        {
            this.TeardownFramework();

            if (disposing && (components != null))
            {
                components.Dispose();
            }
            base.Dispose(disposing);
        }

        public LocalSession LocalSession
        {
            get { return this.Framework.LocalSession; }
        }

        public Context Context
        {
            get { return this.LocalSession.Context; }
        }

        public RemoteSession RemoteSession
        {
            get { return this.Framework.RemoteSession; }
        }

        private String _helpString = "";

        [ComVisible(true)]
        public String HelpString
        {
            get { return _helpString; }
            set { _helpString = value; }
        }

        private String _helpContext = "";

        [ComVisible(true)]
        public String HelpContext
        {
            get { return _helpContext; }
            set { _helpContext = value; }
        }

        private String _helpFile = "";

        [ComVisible(true)]
        public String HelpFile
        {
            get { return _helpFile; }
            set { _helpFile = value; }
        }

        public virtual void AttachToEhr(object aConsumer)
        {
            this.SetupFramework();
            this.Framework.AttachTo(aConsumer);

            if (this.HelpFile.Length == 0)
            {
                this.HelpFileAssemblyName(aConsumer.GetType());
            }
        }
         
        private EhrFramework _framework = null;

        public EhrFramework Framework
        {
            get { return _framework; }
            set { _framework = value; }
        }

        protected void SetupFramework()
        {
            this.Framework = EhrFramework.On(new CIA_CSS.CSS_ServerClass().Session, (IEhrEvents)this, (CIA_CSS.ICSS_SessionEvents)this);
        }

        protected void TeardownFramework()
        {
            if (this.Framework != null)
            {
                this.Framework.Close();
            }
        }

        public event EventHandler<ContextChangedArgs> ContextChanged;
        public event EventHandler<ContextChangingArgs> ContextChanging;

        void CSS_Encounter.ICSS_EncounterEvents.Canceled()
        {
        }

        void CSS_Encounter.ICSS_EncounterEvents.Committed()
        {
            try
            {
                if (this.ContextChanged != null)
                {
                    ContextChangedArgs args = new ContextChangedArgs();
                    args.IsVisitChange = true;
                    args.AfterContext = this.Context;
                    this.ContextChanged.Invoke(this, args);
                }
            }
            catch
            {
            }
        }

        string CSS_Encounter.ICSS_EncounterEvents.Pending(bool Silent)
        {
            try
            {
                if (this.ContextChanging == null)
                {
                    return "";
                }
                else
                {
                    ContextChangingArgs args = new ContextChangingArgs();
                    args.BeforeContext = this.Context;
                    args.IsVisitChange = true;
                    args.Cancel = false;
                    this.ContextChanging.Invoke(this, args);

                    return args.Cancel ? "Cancel" : "";
                }
            }
            catch
            {
                return "";
            }
        }

        void CSS_Patient.ICSS_PatientEvents.Canceled()
        {
        }

        void CSS_Patient.ICSS_PatientEvents.Committed()
        {
            try
            {
                if (this.ContextChanged != null)
                {
                    ContextChangedArgs args = new ContextChangedArgs();
                    args.IsPatientChange = true;
                    args.AfterContext = this.Context;
                    this.ContextChanged.Invoke(this, args);
                }
            }
            catch
            {
            }
        }

        string CSS_Patient.ICSS_PatientEvents.Pending(bool Silent)
        {
            try
            {
                if (this.ContextChanging == null)
                {
                    return "";
                }
                else
                {
                    ContextChangingArgs args = new ContextChangingArgs();
                    args.BeforeContext = this.Context;
                    args.IsPatientChange = true;
                    args.Cancel = false;
                    this.ContextChanging.Invoke(this, args);

                    return args.Cancel ? "Cancel" : "";
                }
            }
            catch
            {
                return "";
            }
        }

        protected virtual void UnhandledException(Exception aProblem)
        {
            MessageBox.Show(aProblem.Message + "  \n\n\n" + aProblem.StackTrace, "Exception");
        }

        protected void HelpFileAssemblyName(Type aType)
        {
            this.HelpFile = aType.Assembly.GetName().Name + ".chm";
        }

  
        public void EventCallback(string anEvent, string aStub)
        {
           this.Framework.IncomingEventCallback(anEvent, aStub);
        }

        public void RPCCallback(int Handle, string Data)
        {
        }

        public void RPCCallbackError(int Handle, int ErrorCode, string ErrorText)
        {
        }

        #endregion

    }


    //Copy this interface too    
    public interface IEhrComponent : IDisposable
    {
        String HelpFile { get; }
        String HelpContext { get; }
        String HelpString { get; }

    }
    
}

